<!-- 

//
//
//Landing Page Shared at CPALanding.com
//https://www.cpalanding.com
//
//

 -->
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
	<head>
		<title>Tik Tok Followers Generator</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		<meta name="description" content="Tik Tok Followers Generator" />    
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<link rel="icon" type="image/ico" href="img/favicon.ico" />
		<!-- Open Graph Meta Tags-->
		<meta property="og:title" content="Tik Tok Followers Generator" /> <!-- Title which is displayed when your site is shared on social networks -->
		<meta property="og:description" content="Tik Tok Followers Generator" /> <!-- Website description which is displayed when your site is shared on social networks -->
		<meta property="og:type" content="website" />
		<meta property="og:url" content="http://www.mywebsiteurl.com/" /> <!-- Your Website URL -->
		<meta property="og:image" content="http://www.mywebsiteurl.com/social-share-image.jpg" />	<!-- Absolute Path to the Image which will display, when your website is shared on social networks -->
		<!-- Twitter Meta -->
		<meta name="twitter:card" content="summary" />
		<meta name="twitter:site" content="@tweetname" />
		<meta name="twitter:title" content="Tweet Title" />
		<meta name="twitter:description" content="Tweet Content" />
		<meta name="twitter:image" content="http://www.mywebsiteurl.com/twitter-share-image.jpg" />
		<!-- Icons -->
		<link rel="stylesheet" href="https://cdn.linearicons.com/free/1.0.0/icon-font.min.css">
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.5.0/css/all.css" integrity="sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU" crossorigin="anonymous">
		<!-- Google Fonts -->
		<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,700,900&display=swap" rel="stylesheet">
		<!-- CSS -->
		<link href="css/bootstrap.min.css" rel="stylesheet" />  
		<link href="css/animate.css" rel="stylesheet" />
		<link href="css/magnific-popup.css" rel="stylesheet" />
		<link href="css/style.css" rel="stylesheet" />
	</head>
	<body>	
		<div class="main-bg"></div>
		<div class="main-wrapper">			
				<header>					
					<div class="branding-wrapper">						
						<img src="img/logo-sign.svg" class="img-fluid logo-img-1" alt="Tik Tok" />
						<img src="img/logo-text.svg" class="img-fluid logo-img-2" alt="Tik Tok" />
					</div>
				</header>
				<div class="after-header-wrapper">
					<h1>Followers Generator</h1>
					<h4>Get free followers for your Tik Tok account.</h4>
					<div class="generator-status">
						<div class="generator-status-content">
							<div class="status-item-wrapper animated bounceIn animation-delay-400">
								<span class="status-label">Status:</span>
								<span id="status" class="status-dynamic">Online</span>
							</div>
							<div class="status-item-wrapper status-item-wrapper-2 animated bounceIn animation-delay-600">
								<span class="status-label">Last Update:</span>
								<span id="date" class="status-dynamic"></span>
							</div>
							<div class="status-item-wrapper animated bounceIn animation-delay-800">
								<span class="status-label">Online Users:</span>
								<span id="online-count" class="status-dynamic"></span>
							</div>
						</div>
					</div>
				</div>
				<div class="main-content">
					<div class="container">
						<div class="generator-wrapper">
							<div class="generator-content">								
								<div class="form-wrapper">
									<img src="img/logo-sign.svg" class="img-fluid logo-img-gen" alt="Tik Tok" />
									<div class="label animated bounceIn animation-delay-400">Your Tik Tok Username</div>
									<div class="animated bounceIn animation-delay-600">
										<div class="input-wrapper username-wrapper">
											<img src="img/input-icon.png" class="input-icon" />
											<input type="text" id="player-username" class="s-input" placeholder="Username..." />
										</div>
									</div>
									<div class="button-wrapper animated bounceIn animation-delay-1000">
										<div id="proc-btn-1" class="tkt-btn">
											<span>Connect</span>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="bg-detail"><img src="img/tik-tok-bg-detail.png" class="img-fluid bt-detail-img" /></div>
				</div>		
		</div>
		<div class="modal-outer"></div>
	</body>
	<!-- JS -->	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
	<script type="text/javascript" src="js/jquery.magnific-popup.min.js"></script>	
	<script type="text/javascript" src="js/ion.sound.min.js"></script>	
    <script type="text/javascript" src="js/jquery.countTo.js"></script>
    <script type="text/javascript" src="js/main.js"></script>
</html>